/**
* Script: audio.js
* Written by: Radnen
* Updated: 1/4/2011
**/

/**
* AudioEngine 2.0:
* - Global audio manager.
**/
var Audio = ({
	fade: new TimedValue(255, 0),
	music: null,
	bgm: null,
	sounds: [],
	playlist: [], // Set this to an array of sound objects to use the playlist feature.
	pauselist: true,
	filename: "",
	filenames: [], // Playlist filenames //
	descriptions: [], // Textual description; name of song //
	time: GetTime(),
	msecs: 0,
	max: 200,
	smax: 220,
	current: 0,
	displayInformation: false,
	font: GetSystemFont(),
	ticks: 0,
	maxTicks: 200,
	muteAll: false,
	changeSong: null,
	changed: false,

	changeMusic: function(song) {
		this.fadeOut(500);
		this.changeSong = song;
		this.changed = true;
	},
	
	playBgm: function(bgm) {
		if (this.bgm) this.bgm.stop();
		this.bgm = bgm;
		this.bgm.play(true);
	},
	
	stopBgm: function() {
		if (this.bgm) this.bgm.stop();
	},

	// Sound can be a filename or it can be a sound object.
	// However, sound objects lose filename data!
	play: function(song, repeat, pitch) {
		if (repeat === undefined) repeat = true;

		if (pitch === undefined) this.pitch = 1.0;
		else this.pitch = pitch;

		// Filename //
		if (typeof song == "string") {
			if (song != "" && song != this.filename) {
				if (this.music != null) this.music.stop();
				this.music = LoadSound(song);
				this.filename = song;
			}
		}

		// Object //
		else if (song != null) {
			if (this.music != null) this.music.stop();
			this.music = song;
			this.filename = "";
		}
		else Abort("Error: Invalid sound object", "Rad_Sound.js", 74);

		if (!this.muteAll) this.music.play(repeat);
		this.music.setVolume(this.max);
		this.music.setPitch(this.pitch);
	},
	
	setVolume: function(num) {
		if (this.music != null) this.music.setVolume(num);
	},

	setPitch: function(num) {
		this.music.setPitch(num);
	},

	playSound: function(sound) {
		sound.stop();
		if (!this.muteAll) sound.play(false);
		sound.setVolume(this.smax);
	},

	stop: function() {
		if (this.music != null && this.music.isPlaying()) {
			this.music.stop();
			this.music = null;
			this.filename = "";
		}
	},

	waitForFade: function() {
		SetFrameRate(GetMapEngineFrameRate());
		while(this.fade != 0) {
			UpdateMapEngine();
			RenderMap();
			FlipScreen();
		}
		SetFrameRate(0);
	},

	// Use this to add a list of songs by supplying an array of filenames.
	addPlaylist: function(playlist, descriptions) {
	if (descriptions != undefined) this.descriptions = descriptions;
		for(var i = 0; i < playlist.length; ++i) {
			this.playlist[i] = LoadSound(playlist[i]);
		}
		this.filenames = playlist;
	},

	// Call this whenever you want to fade the current music in //
	fadeIn: function(msecs, amt) {
		if (this.music == null) return;
		if (!amt) amt = this.max;
		
		this.music.setVolume(0);
		this.fade.value = 0;
		this.fade.duration = msecs;
		this.fade.scale(amt);
	},

	// Call this whenever you want to fade the current music out //
	fadeOut: function(msecs, amt) {
		if (this.music == null) return;
		if (!amt) amt = 0;
		
		this.music.setVolume(this.max);
		this.fade.value = this.max;
		this.fade.duration = msecs;
		this.fade.scale(amt);
	},

	reset: function() {
		this.stop();
		this.fade.value = this.max;
	},

	// Use this to enable the playllist feature.
	enablePlaylisting: function() {
		if (this.playlist.length > 0) {
			if (this.filename != "") this.music.stop();
			this.pauselist = false;
			this.playlist[this.current].play(false);
		}
	},

	// Use this to disable it.
	disablePlaylisting: function(reset) {
		this.playlist[this.current].stop();
		this.pauselist = true;
		if(reset != undefined) this.current = 0;
	},

	// Call this in an update loop //
	update: function() {
		if (this.music != null) {
			this.music.setVolume(this.fade.value);
		}
		if (!this.fade.update()) {
			if (this.changeSong != null) {
				this.play(this.changeSong);
				this.fadeIn(500);
				this.changeSong = null;
			}
		}
	},
});